#version 120
/* DRAWBUFFERS:01 */

#define gbuffers_terrain
#include "shaders.settings"

varying vec4 color;
varying vec4 normal;
varying float lmcoord;

//encode normal in two channel (xy), emissive lightmap (z) and sky lightmap (w), blend mode must be disabled in shaders.properties for this to work without issues.
vec4 encode (vec3 n){
    return vec4(n.xy*inversesqrt(n.z*8.0+8.0) + 0.5, lmcoord, 1.0); // set sky lightmap to 1 for distant horizons
}

vec3 RGB2YCoCg(vec3 c){
	return vec3( 0.25*c.r+0.5*c.g+0.25*c.b, 0.5*c.r-0.5*c.b +0.5, -0.25*c.r+0.5*c.g-0.25*c.b +0.5);
}

void main() {

	vec4 cAlbedo = vec4(RGB2YCoCg(color.rgb),color.a);

	bool pattern = (mod(gl_FragCoord.x,2.0)==mod(gl_FragCoord.y,2.0));
	cAlbedo.g = (pattern)?cAlbedo.b: cAlbedo.g;
	cAlbedo.b = normal.a;

	gl_FragData[0] = cAlbedo;
	gl_FragData[1] = encode(normal.xyz);

}