/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.particle;

import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ParticleVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.class_11944;
import net.minecraft.class_4588;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_11944.class})
public abstract class QuadParticleRenderStateMixin {
    @Unique
    private static final Quaternionf TEMP_QUAT = new Quaternionf();
    @Unique
    private static final Vector3f TEMP_VECTOR = new Vector3f();

    @Inject(method={"method_74321(Lnet/minecraft/class_4588;FFFFFFFFFFFFII)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void render(class_4588 vertexConsumer, float x, float y, float z, float quatX, float quatY, float quatZ, float quatW, float size, float u0, float u1, float v0, float v1, int color, int light, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        TEMP_QUAT.set(quatX, quatY, quatZ, quatW);
        this.sodium$emitVertices(writer, x, y, z, size, u0, u1, v0, v1, ColorARGB.toABGR(color), light, TEMP_QUAT);
    }

    @Unique
    private void sodium$emitVertices(VertexBufferWriter writer, float x, float y, float z, float size, float u0, float u1, float v0, float v1, int color, int light, Quaternionf quaternion) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            TEMP_VECTOR.set(1.0f, -1.0f, 0.0f).rotate((Quaternionfc)quaternion).mul(size).add(x, y, z);
            ParticleVertex.put(ptr, QuadParticleRenderStateMixin.TEMP_VECTOR.x, QuadParticleRenderStateMixin.TEMP_VECTOR.y, QuadParticleRenderStateMixin.TEMP_VECTOR.z, u1, v1, color, light);
            TEMP_VECTOR.set(1.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternion).mul(size).add(x, y, z);
            ParticleVertex.put(ptr += 28L, QuadParticleRenderStateMixin.TEMP_VECTOR.x, QuadParticleRenderStateMixin.TEMP_VECTOR.y, QuadParticleRenderStateMixin.TEMP_VECTOR.z, u1, v0, color, light);
            TEMP_VECTOR.set(-1.0f, 1.0f, 0.0f).rotate((Quaternionfc)quaternion).mul(size).add(x, y, z);
            ParticleVertex.put(ptr += 28L, QuadParticleRenderStateMixin.TEMP_VECTOR.x, QuadParticleRenderStateMixin.TEMP_VECTOR.y, QuadParticleRenderStateMixin.TEMP_VECTOR.z, u0, v0, color, light);
            TEMP_VECTOR.set(-1.0f, -1.0f, 0.0f).rotate((Quaternionfc)quaternion).mul(size).add(x, y, z);
            ParticleVertex.put(ptr += 28L, QuadParticleRenderStateMixin.TEMP_VECTOR.x, QuadParticleRenderStateMixin.TEMP_VECTOR.y, QuadParticleRenderStateMixin.TEMP_VECTOR.z, u0, v1, color, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }
}

