/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation;

import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.Abstract2DLinearEstimator;

public abstract class ExpDecayLinear2DEstimator<C>
extends Abstract2DLinearEstimator<C, ClearingLinearRegressionBatch<C>, ExpDecayLinearFunction<C>> {
    private final double newDataRatio;
    private final int initialSampleTarget;
    private final int minBatchSize;

    public ExpDecayLinear2DEstimator(double newDataRatio, int initialSampleTarget, int minBatchSize, long initialOutput) {
        super(initialOutput);
        this.newDataRatio = newDataRatio;
        this.initialSampleTarget = initialSampleTarget;
        this.minBatchSize = minBatchSize;
    }

    @Override
    protected ClearingLinearRegressionBatch<C> createNewDataBatch() {
        return new ClearingLinearRegressionBatch();
    }

    @Override
    protected ExpDecayLinearFunction<C> createNewModel() {
        return new ExpDecayLinearFunction(this.newDataRatio, this.initialSampleTarget, this.minBatchSize, this.initialOutput);
    }

    protected static class ClearingLinearRegressionBatch<C>
    extends Abstract2DLinearEstimator.LinearRegressionBatch<C> {
        boolean deferredClear = false;

        protected ClearingLinearRegressionBatch() {
        }

        @Override
        public void reset() {
            if (!this.deferredClear) {
                this.clear();
            }
            this.deferredClear = false;
        }

        private boolean checkUpdateDefer(int minBatchSize) {
            if (this.size() < minBatchSize) {
                this.deferredClear = true;
                return true;
            }
            return false;
        }
    }

    protected static class ExpDecayLinearFunction<C>
    extends Abstract2DLinearEstimator.LinearFunction<C, ClearingLinearRegressionBatch<C>> {
        private final double newDataRatioInv;
        private final int initialSampleTarget;
        private final int minBatchSize;
        private double xMeanOld = 0.0;
        private double yMeanOld = 0.0;
        private double covarianceOld = 0.0;
        private double varianceOld = 0.0;

        public ExpDecayLinearFunction(double newDataRatio, int initialSampleTarget, int minBatchSize, long initialOutput) {
            super(initialOutput);
            this.newDataRatioInv = 1.0 / newDataRatio;
            this.initialSampleTarget = initialSampleTarget;
            this.minBatchSize = minBatchSize;
        }

        @Override
        public void update(ClearingLinearRegressionBatch<C> batch) {
            double oldDataWeight;
            double totalWeight;
            if (batch.isEmpty() || batch.checkUpdateDefer(this.minBatchSize)) {
                return;
            }
            int newDataSize = batch.size();
            int totalSamples = this.gatheredSamples + newDataSize;
            if (totalSamples <= this.initialSampleTarget) {
                totalWeight = totalSamples;
                oldDataWeight = this.gatheredSamples;
                this.gatheredSamples = totalSamples;
            } else {
                oldDataWeight = (double)newDataSize * this.newDataRatioInv - (double)newDataSize;
                totalWeight = oldDataWeight + (double)newDataSize;
            }
            double totalWeightInv = 1.0 / totalWeight;
            long xSum = 0L;
            long ySum = 0L;
            ObjectListIterator objectListIterator = batch.iterator();
            while (objectListIterator.hasNext()) {
                Abstract2DLinearEstimator.DataPair data = (Abstract2DLinearEstimator.DataPair)objectListIterator.next();
                xSum += data.x();
                ySum += data.y();
            }
            double xMean = (this.xMeanOld * oldDataWeight + (double)xSum) * totalWeightInv;
            double yMean = (this.yMeanOld * oldDataWeight + (double)ySum) * totalWeightInv;
            double covarianceSum = 0.0;
            double varianceSum = 0.0;
            ObjectListIterator objectListIterator2 = batch.iterator();
            while (objectListIterator2.hasNext()) {
                Abstract2DLinearEstimator.DataPair data = (Abstract2DLinearEstimator.DataPair)objectListIterator2.next();
                double xDelta = (double)data.x() - xMean;
                double yDelta = (double)data.y() - yMean;
                covarianceSum += xDelta * yDelta;
                varianceSum += xDelta * xDelta;
            }
            if (Math.abs(varianceSum) <= Double.MIN_NORMAL) {
                return;
            }
            this.slope = Math.max(0.0, (covarianceSum += this.covarianceOld * oldDataWeight) / (varianceSum += this.varianceOld * oldDataWeight));
            this.yIntercept = yMean - this.slope * xMean;
            this.xMeanOld = xMean;
            this.yMeanOld = yMean;
            this.covarianceOld = covarianceSum * totalWeightInv;
            this.varianceOld = varianceSum * totalWeightInv;
        }
    }
}

